// Minimal xAPI Wrapper for SLS
(function(window) {
  var xAPIWrapper = function() {
    this.lrs = null;
  };
  
  xAPIWrapper.prototype.changeConfig = function(config) {
    this.lrs = {
      endpoint: config.endpoint,
      auth: config.auth,
      actor: config.actor,
      activity_id: config.activity_id
    };
  };
  
  xAPIWrapper.prototype.sendStatement = function(stmt) {
    if (!this.lrs || !this.lrs.endpoint) {
      console.warn('xAPI: No LRS configured');
      return Promise.resolve(null);
    }
    
    return fetch(this.lrs.endpoint + '/statements', {
      method: 'POST',
      headers: {
        'Content-Type': 'application/json',
        'Authorization': 'Basic ' + this.lrs.auth,
        'X-Experience-API-Version': '1.0.3'
      },
      body: JSON.stringify(stmt)
    }).then(r => r.json()).catch(e => console.error('xAPI send failed:', e));
  };
  
  window.ADL = window.ADL || {};
  window.ADL.XAPIWrapper = new xAPIWrapper();
})(window);